/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.VWDesignerMapNameUtil;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWDesignerMapListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final int MAX_NAME_LENGTH = 25;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWDesignerMapNameUtil m_mapNameUtil = null;

    public VWDesignerMapListCellRenderer(VWAuthPropertyData authPropertyData) {
        this.setOpaque(true);
        this.m_authPropertyData = authPropertyData;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            if (value != null && value instanceof VWMap) {
                if (list != null) {
                    this.setComponentOrientation(list.getComponentOrientation());
                    this.setFont(list.getFont());
                    this.setEnabled(list.isEnabled());
                    if (isSelected) {
                        this.setBackground(list.getSelectionBackground());
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setBackground(list.getBackground());
                        this.setForeground(list.getForeground());
                    }
                }
                VWMap vwMap = (VWMap)value;
                String mapName = null;
                if (this.m_mapNameUtil == null && this.m_authPropertyData.getMapCache() != null) {
                    this.m_mapNameUtil = new VWDesignerMapNameUtil(this.m_authPropertyData.getMapCache());
                }
                if (this.m_mapNameUtil != null) {
                    mapName = this.m_mapNameUtil.getPrettyName(vwMap);
                    this.setIcon(this.m_mapNameUtil.getMapIcon(vwMap));
                } else {
                    if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                        this.setText(VWResource.s_mainMapLabel.toString(mapName));
                    } else {
                        this.setText(mapName);
                    }
                    this.setIcon(null);
                }
                this.setToolTipText(mapName);
                if (mapName != null && mapName.length() > 25) {
                    mapName = VWResource.s_ellipse.toString(mapName.substring(0, 25));
                }
                this.setText(mapName);
            } else {
                this.setText(null);
                this.setIcon(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

